/*-----------------------------------------------------------------------------

 1999, Steinberg Soft und Hardware GmbH, All Rights Reserved

-----------------------------------------------------------------------------*/

/*
  a simple 3 oscillator test 'synth',
  each oscillator has waveform, frequency, and volume
*/

#ifndef __VstXSynth__
#define __VstXSynth__

#include <string.h>

#ifndef __AudioEffectX__
#include "audioeffectx.h"
#endif

const double Pi = 3.141592653f;

enum
{
	kNumPrograms = 32,
	kNumOutputs = 3,

	kWaveform1 = 0,
	kFreq1,
	kVolume1,

	kWaveform2,
	kFreq2,
	kVolume2,

	kWaveform3,
	kFreq3,
	kVolume3,

	kVolume,
	
	kTest,

	kNumParams
};

class VstXSynthProgram
{
friend class VstXSynth;
public:
	VstXSynthProgram();
	~VstXSynthProgram() {}
private:
	float fWaveform1;
	float fFreq1;
	float fVolume1;
	float fWaveform2;
	float fFreq2;
	float fVolume2;
	float fWaveform3;
	float fFreq3;
	float fVolume3;
	float fVolume;
	char name[24];
};

//------------------------------------------------------------------------------------------
class VstXSynth : public AudioEffectX
{
friend class MoogProgram;
public:
	VstXSynth(audioMasterCallback audioMaster);
	~VstXSynth();

	virtual void process(float **inputs, float **outputs, long sampleframes);
	virtual void processReplacing(float **inputs, float **outputs, long sampleframes);
	virtual long processEvents(VstEvents* events);

	virtual void setProgram(long program);
	virtual void setProgramName(char *name);
	virtual void getProgramName(char *name);
	virtual void setParameter(long index, float value);
	virtual float getParameter(long index);
	virtual void getParameterLabel(long index, char *label);
	virtual void getParameterDisplay(long index, char *text);
	virtual void getParameterName(long index, char *text);
	virtual void setSampleRate(float sampleRate);
	virtual void setBlockSize(long blockSize);
	virtual void resume();

	virtual bool getOutputProperties (long index, VstPinProperties* properties);
	virtual bool getProgramNameIndexed (long category, long index, char* text);
	virtual bool copyProgram (long destination);
	virtual bool getEffectName (char* name);
	virtual bool getVendorString (char* text);
	virtual bool getProductString (char* text);
	virtual long getVendorVersion () {return 1;}
	virtual long canDo (char* text);

private:
	void initProcess();
	void noteOn(long note, long velocity, long delta);

	float fWaveform1;
	float fFreq1;
	float fVolume1;
	float fWaveform2;
	float fFreq2;
	float fVolume2;
	float fWaveform3;
	float fFreq3;
	float fVolume3;
	float fVolume;
	
	float fPhase1, fPhase2, fPhase3;
	float fScaler;
	VstXSynthProgram* programs;

	long currentNote;
	long currentVelocity;
	long currentDelta;
	bool noteIsOn;
};

#endif
